package chess4j.pieces;

import chess4j.Color;
import chess4j.board.directions.NorthEast;
import chess4j.board.directions.NorthWest;
import chess4j.board.directions.SouthEast;
import chess4j.board.directions.SouthWest;

public class Bishop extends SlidingPiece {

	public static final Bishop WHITE_BISHOP = new Bishop(Color.WHITE);
	public static final Bishop BLACK_BISHOP = new Bishop(Color.BLACK);
	
	private Bishop(Color color) {
		super(color);
	}
	
	public String toString() {
		return isWhite()?"B":"b";
	}

	@Override
	protected void addDirections() {
		_dirs.add(SouthEast.getInstance());
		_dirs.add(SouthWest.getInstance());
		_dirs.add(NorthEast.getInstance());
		_dirs.add(NorthWest.getInstance());		
	}
}
